<?php

use App\Http\Controllers\Api\AttachmentController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\OccurrenceController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Auth Routes (Public)
|--------------------------------------------------------------------------
*/
Route::prefix('auth')->group(function () {
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/verify-otp', [AuthController::class, 'verifyOtp']);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/send-otp', [AuthController::class, 'sendOtp']);
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
    Route::post('/reset-password', [AuthController::class, 'resetPassword']);
});

/*
|--------------------------------------------------------------------------
| Authenticated Routes
|--------------------------------------------------------------------------
*/
Route::middleware('auth:sanctum')->group(function () {

    // Auth (authenticated)
    Route::prefix('auth')->group(function () {
        Route::post('/logout', [AuthController::class, 'logout']);
        Route::get('/profile', [AuthController::class, 'profile']);
        Route::put('/profile', [AuthController::class, 'updateProfile']);
        Route::put('/change-password', [AuthController::class, 'changePassword']);
        Route::delete('/account', [AuthController::class, 'deleteAccount']);
    });

    // Categories
    Route::prefix('categories')->group(function () {
        Route::get('/', [CategoryController::class, 'index']);
        Route::post('/', [CategoryController::class, 'store']);
        Route::put('/reorder', [CategoryController::class, 'reorder']);
        Route::put('/{category}', [CategoryController::class, 'update']);
        Route::delete('/{category}', [CategoryController::class, 'destroy']);
    });

    // Notifications
    Route::prefix('notifications')->group(function () {
        Route::get('/', [NotificationController::class, 'index']);
        Route::post('/', [NotificationController::class, 'store']);
        Route::get('/{notification}', [NotificationController::class, 'show']);
        Route::put('/{notification}', [NotificationController::class, 'update']);
        Route::delete('/{notification}', [NotificationController::class, 'destroy']);
        Route::patch('/{notification}/toggle', [NotificationController::class, 'toggle']);
        Route::patch('/{notification}/skip-next', [NotificationController::class, 'skipNext']);

        // Attachments
        Route::post('/{notification}/attachments', [AttachmentController::class, 'store']);
    });

    // Occurrences
    Route::prefix('occurrences')->group(function () {
        Route::get('/', [OccurrenceController::class, 'index']);
        Route::patch('/{occurrence}/complete', [OccurrenceController::class, 'complete']);
        Route::patch('/{occurrence}/dismiss', [OccurrenceController::class, 'dismiss']);
        Route::patch('/{occurrence}/snooze', [OccurrenceController::class, 'snooze']);
        Route::patch('/{occurrence}/skip', [OccurrenceController::class, 'skip']);
    });

    // Dashboard
    Route::prefix('dashboard')->group(function () {
        Route::get('/today', [DashboardController::class, 'today']);
        Route::get('/summary', [DashboardController::class, 'summary']);
        Route::get('/calendar', [DashboardController::class, 'calendar']);
        Route::get('/upcoming', [DashboardController::class, 'upcoming']);
    });

    // Attachments (delete)
    Route::delete('/attachments/{attachment}', [AttachmentController::class, 'destroy']);
});
