<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['name' => 'Bill', 'icon' => 'receipt', 'color' => '#F44336', 'sort_order' => 1],
            ['name' => 'Bank/Finance', 'icon' => 'account_balance', 'color' => '#4CAF50', 'sort_order' => 2],
            ['name' => 'Medicine/Health', 'icon' => 'medical_services', 'color' => '#FF9800', 'sort_order' => 3],
            ['name' => 'Subscriptions', 'icon' => 'subscriptions', 'color' => '#9C27B0', 'sort_order' => 4],
            ['name' => 'Birthdays/Events', 'icon' => 'cake', 'color' => '#E91E63', 'sort_order' => 5],
            ['name' => 'Work/Tasks', 'icon' => 'work', 'color' => '#2196F3', 'sort_order' => 6],
            ['name' => 'Custom', 'icon' => 'notifications', 'color' => '#607D8B', 'sort_order' => 7],
        ];

        foreach ($categories as $category) {
            Category::create(array_merge($category, [
                'user_id' => null,
                'is_default' => true,
            ]));
        }
    }
}
