<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notification_occurrences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('notification_id')->constrained()->cascadeOnDelete();
            $table->dateTime('scheduled_at');
            $table->enum('status', [
                'pending', 'delivered', 'snoozed', 'dismissed', 'completed', 'skipped'
            ])->default('pending');
            $table->dateTime('snoozed_until')->nullable();
            $table->dateTime('acted_at')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index(['notification_id', 'status']);
            $table->index(['scheduled_at', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notification_occurrences');
    }
};
