<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('category_id')->constrained()->cascadeOnDelete();
            $table->string('title');
            $table->text('description')->nullable();
            $table->enum('frequency_type', [
                'one_time', 'daily', 'weekly', 'bi_weekly', 'monthly',
                'quarterly', 'yearly', 'custom', 'weekdays', 'weekends'
            ]);
            $table->json('frequency_config')->nullable();
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->integer('remind_before_minutes')->default(0);
            $table->enum('priority', ['low', 'medium', 'high', 'critical'])->default('medium');
            $table->decimal('amount', 10, 2)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['user_id', 'is_active']);
            $table->index(['user_id', 'category_id']);
            $table->index('start_date');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
