<?php

namespace Database\Factories;

use App\Models\Category;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class NotificationFactory extends Factory
{
    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'category_id' => Category::factory(),
            'title' => fake()->sentence(3),
            'description' => fake()->optional()->sentence(),
            'frequency_type' => fake()->randomElement([
                'one_time', 'daily', 'weekly', 'monthly', 'yearly',
            ]),
            'frequency_config' => ['time_slots' => ['09:00']],
            'start_date' => now()->format('Y-m-d'),
            'end_date' => null,
            'remind_before_minutes' => 0,
            'priority' => fake()->randomElement(['low', 'medium', 'high', 'critical']),
            'amount' => fake()->optional()->randomFloat(2, 10, 10000),
            'is_active' => true,
        ];
    }
}
