<?php

namespace App\Services;

use App\Mail\OtpMail;
use App\Models\OtpCode;
use Illuminate\Support\Facades\Mail;

class OtpService
{
    public function generate(string $email, string $type, ?int $userId = null): OtpCode
    {
        // Invalidate any existing unused OTPs for this email and type
        OtpCode::where('email', $email)
            ->where('type', $type)
            ->whereNull('verified_at')
            ->delete();

        $otp = OtpCode::create([
            'user_id' => $userId,
            'email' => $email,
            'type' => $type,
            'code' => str_pad((string) random_int(0, 999999), 6, '0', STR_PAD_LEFT),
            'expires_at' => now()->addMinutes(10),
        ]);

        Mail::to($email)->send(new OtpMail($otp));

        return $otp;
    }

    public function verify(string $email, string $code, string $type): ?OtpCode
    {
        $otp = OtpCode::where('email', $email)
            ->where('code', $code)
            ->where('type', $type)
            ->whereNull('verified_at')
            ->where('expires_at', '>', now())
            ->latest()
            ->first();

        if (!$otp) {
            return null;
        }

        $otp->update(['verified_at' => now()]);

        return $otp;
    }
}
