<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NotificationOccurrence extends Model
{
    protected $fillable = [
        'notification_id',
        'scheduled_at',
        'status',
        'snoozed_until',
        'acted_at',
        'notes',
    ];

    protected function casts(): array
    {
        return [
            'scheduled_at' => 'datetime',
            'snoozed_until' => 'datetime',
            'acted_at' => 'datetime',
        ];
    }

    public function notification(): BelongsTo
    {
        return $this->belongsTo(Notification::class);
    }
}
