<?php

namespace App\Mail;

use App\Models\OtpCode;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class OtpMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public OtpCode $otpCode)
    {
    }

    public function envelope(): Envelope
    {
        $subject = match ($this->otpCode->type) {
            'signup' => 'Verify Your Email - Remindr',
            'password_reset' => 'Password Reset OTP - Remindr',
            default => 'Your OTP Code - Remindr',
        };

        return new Envelope(subject: $subject);
    }

    public function content(): Content
    {
        return new Content(view: 'emails.otp');
    }
}
