<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OccurrenceResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'notification_id' => $this->notification_id,
            'scheduled_at' => $this->scheduled_at->toISOString(),
            'status' => $this->status,
            'snoozed_until' => $this->snoozed_until?->toISOString(),
            'acted_at' => $this->acted_at?->toISOString(),
            'notes' => $this->notes,
            'notification' => new NotificationResource($this->whenLoaded('notification')),
            'created_at' => $this->created_at->toISOString(),
        ];
    }
}
