<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'frequency_type' => $this->frequency_type,
            'frequency_config' => $this->frequency_config,
            'start_date' => $this->start_date->format('Y-m-d'),
            'end_date' => $this->end_date?->format('Y-m-d'),
            'remind_before_minutes' => $this->remind_before_minutes,
            'priority' => $this->priority,
            'amount' => $this->amount,
            'is_active' => $this->is_active,
            'category' => new CategoryResource($this->whenLoaded('category')),
            'attachments' => AttachmentResource::collection($this->whenLoaded('attachments')),
            'next_occurrence' => new OccurrenceResource($this->whenLoaded('nextOccurrence')),
            'occurrences_count' => $this->whenCounted('occurrences'),
            'created_at' => $this->created_at->toISOString(),
            'updated_at' => $this->updated_at->toISOString(),
        ];
    }
}
