<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'icon' => $this->icon,
            'color' => $this->color,
            'is_default' => $this->is_default,
            'sort_order' => $this->sort_order,
            'user_id' => $this->user_id,
            'notifications_count' => $this->whenCounted('notifications'),
            'created_at' => $this->created_at->toISOString(),
        ];
    }
}
