<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateProfileRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['sometimes', 'string', 'max:255'],
            'email' => ['sometimes', 'email', Rule::unique('users')->ignore($this->user()->id)],
            'avatar_url' => ['sometimes', 'nullable', 'url'],
            'fcm_token' => ['sometimes', 'nullable', 'string'],
            'preferences' => ['sometimes', 'nullable', 'array'],
            'preferences.timezone' => ['sometimes', 'string', 'timezone:all'],
        ];
    }
}
