<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreNotificationRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'category_id' => ['required', 'exists:categories,id'],
            'title' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:1000'],
            'frequency_type' => ['required', 'in:one_time,daily,weekly,bi_weekly,monthly,quarterly,yearly,custom,weekdays,weekends'],
            'frequency_config' => ['nullable', 'array'],
            'frequency_config.selected_days' => ['nullable', 'array'],
            'frequency_config.selected_days.*' => ['integer', 'min:1', 'max:7'],
            'frequency_config.day_of_month' => ['nullable', 'integer', 'min:1', 'max:31'],
            'frequency_config.interval_days' => ['nullable', 'integer', 'min:1'],
            'frequency_config.time_slots' => ['nullable', 'array', 'min:1'],
            'frequency_config.time_slots.*' => ['date_format:H:i'],
            'start_date' => ['required', 'date'],
            'end_date' => ['nullable', 'date', 'after_or_equal:start_date'],
            'remind_before_minutes' => ['nullable', 'integer', 'min:0'],
            'priority' => ['nullable', 'in:low,medium,high,critical'],
            'amount' => ['nullable', 'numeric', 'min:0'],
        ];
    }
}
